import heapq

def srediMatricu(brojevi, red, kol):
    sortiraniBrojevi = sorted(brojevi, reverse=True)
    matrica = [[0] * kol for _ in range(red)]
    
    srednjiRed, srednjaKolona = red // 2, kol // 2
    
    pq = []
    for i in range(red):
        for j in range(kol):
            dist = abs(i - srednjiRed) + abs(j - srednjaKolona)
            heapq.heappush(pq, (dist, (i, j)))
    for broj in sortiraniBrojevi:
        najmanjaDist, najmanjaPoz = heapq.heappop(pq)
        
        matrica[najmanjaPoz[0]][najmanjaPoz[1]] = broj
    
    return matrica

def nadjiPodmatrice(N, M, K, L, matrica):
    broj = 0
    for i in range(N - K + 1):
        for j in range(M - L + 1):
            zbirPodmatrica = sum(matrica[x][y] for x in range(i, i + K) for y in range(j, j + L))
            broj += zbirPodmatrica

    return broj

N, M, K, L = map(int, input().split())
brojevi = list(map(int, input().split()))

sredjenaMatrica = srediMatricu(brojevi, N, M)
result = nadjiPodmatrice(N, M, K, L, sredjenaMatrica)
print(result)